#pragma once

#ifndef SERVICE_H
#define SERVICE_H

/*GSM 07.07 standard errors*/
#define kNoError										-1
#define kPhoneFailure									0
#define kNoConnectionToPhone							1
#define kPhoneAdaptatorLinkReserved						2
#define kOprationNotAllowed								3
#define kOperationNotSupported							4
#define kPH_SIM_PIN_Required							5
#define kPH_FSIM_PIN_Required							6
#define kPH_FSIM_PUK_Required							7
#define kSIM_NotInsetered								10
#define kSIM_PIN_Required								11
#define kSIM_PUK_Required								12
#define kSIM_Failure									13
#define kSIM_Busy										14
#define kSIM_Wrong										15
#define kIncorrectPassowrd								16
#define kSIM_PIN2_Required								17
#define kSIM_PUK2_Required								18
#define kMemoryFull										20
#define kInvalidIndex									21
#define kNotFound										22
#define kMemoryFailure									23
#define kTextStringTooLong								24
#define kInvalidCharacterInTextString					25
#define kDialStringTooLong								26
#define kInvalidCharacterInDialString					27
#define kNoNetworkService								30
#define kNetworkTimeout									31
#define kNetworkNotAllowed_emergencyOnly				32
#define kNetwork_personalisation_PIN_Required			40
#define kNetworkPersonalisation_PUK_Required			41
#define kNetworkSubsetPersonalisation_PIN_Required		42
#define kNetworkSubsetPersonalisation_PUK_Required		43
#define kServiceProviderPersonalisation_PIN_Required	44
#define kServiceProviderPersonalisation_PUK_Required	45
#define kCorporatePersonalisation_PIN_Required			46
#define kCorporatePersonalisation_PUK_Required			47
#define kUnknown										100

//GPRS Error related
#define kIllegalMS										103
#define kIllegalME										106
#define kGPRS_ServiceNotAllowed							107
#define kPLMN_NotAllowed								111
#define kLoacationAreaNotAllowed						112
#define kRoamingNotAllowedInThisLocationArea			113

//SMS Error Related
#define kNoAvailableMessageStorage						302
#define kInvalidMemoryIndex								321

//OTHER
// return "ERROR" must be same value as defined in Interpretor.h (1005)
#define kERROR											1005
// indicate that we don't wan't to send any response (error simulation)
#define  kNoResponse									1013

/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "DllManager.h"
#include "Listener.h"
#include "Config.h"
#include "ConfigDlg.h"
#include "ServiceDlg.h"
#include <afxmt.h>
///////////////////////////////////////////////////////////////////////
// CService command target
class CServiceDlg;
class CDllManager;
class CConfig;
///////////////////////////////////////////////////////////////////////
class COMMON_API CService : public CObject, public CListener
{
protected:	
	CList<StructAT,StructAT&> mStructCmdList;	
	CDllManager* mDllManager;
	CCriticalSection mCS;
	CServiceDlg* mServiceUI;
	bool mExecuteCmd; // state of a the service, true if in the dispatcher
	CList<CServiceDlg*,CServiceDlg*&> mDlgList;

	/*DllGenerator sprcific*/
	CString mClassName;
	CString mBasedName;	

	virtual void AddCmd(StructAT iStructAT);
	virtual void RemoveCmd(CString iCmdName);
	virtual StructAT GetCmd(CString iCmdName);

public:	
	CService() {};
	CService(CDllManager* iDllManager);
	virtual ~CService();

	virtual Bool Dispatch(CCmd* iCmdP)=0;	
	virtual Bool ProcessData(CDataMessage* iData){return true;};
	virtual void SetDllManager(CDllManager* iDllManager);
	virtual void OnConfigChange(int configID)=0;
	virtual void OnConfigChange(int configID, int iConfigEvent) {};
	virtual CList<StructAT,StructAT&>* GetStructCmdList();
	virtual int GetCmdTableLength();
	virtual CConfig* GetConfig(WORD iCfgID);
	virtual bool IsExecutingCmd();
	virtual void StartExecutingCmd();
	virtual void StopExecutingCmd();
	virtual CServiceDlg* GetServiceUI();
	// Add a Dialog to this Service
    virtual void AddDialog(CServiceDlg* iDlg);
	// Remove a Dialog
	virtual void RemoveDialog(CServiceDlg* iDlg);
	// Remove a Dialog by this name
	virtual void RemoveDialog(CString iDlgName);
	// Return the number of dialogs owned
	virtual INT_PTR GetDialogCount();
	// Get the iIndex Dialog
	virtual CServiceDlg* GetDialog(int iIndex);
	
	/*DllGenerator sprcific*/
	virtual CString GetClassName();
	virtual CString getBasedName();


	/*Formatting API*/
public:
	virtual void FormatATMsg(CString iMsg, CCmd* iCmd, Bool iSilentMode, Bool iForced=FALSE);
	virtual void FormatATStdError(UINT iErrorID, CCmd* iCmd, Bool iSilentMode);
	virtual void FormatATError(CCmd* iCmd, Bool iSilentMode);
	virtual void FormatATOK(CCmd* iCmd, Bool iSilentMode, Bool iForced=FALSE);
	
	virtual void AppendVPMsg(CString iMsg, int iIconID=-1);

};
///////////////////////////////////////////////////////////////////////

#endif


